# Panduan Instalasi Sistem Manajemen Teknisi AC

## Persyaratan Sistem

### Software yang Diperlukan
- **PHP**: Versi 8.1 atau lebih tinggi
- **MySQL**: Versi 5.7 atau lebih tinggi (atau MariaDB 10.3+)
- **Web Server**: Apache 2.4+ atau Nginx 1.15+
- **Composer**: Package manager untuk PHP

### Ekstensi PHP yang Diperlukan
- `php-mysqli` atau `php-mysqlnd`
- `php-mbstring`
- `php-json`
- `php-xml`
- `php-curl`
- `php-intl`

## Langkah Instalasi

### 1. Persiapan Environment

#### Untuk XAMPP (Windows/Mac/Linux)
1. Download dan install XAMPP dari https://www.apachefriends.org/
2. Jalankan Apache dan MySQL dari XAMPP Control Panel
3. Pastikan PHP versi 8.1+ (cek di phpinfo())

#### Untuk LAMP (Linux)
```bash
# Ubuntu/Debian
sudo apt update
sudo apt install apache2 mysql-server php8.1 php8.1-mysql php8.1-mbstring php8.1-xml php8.1-curl php8.1-intl

# CentOS/RHEL
sudo yum install httpd mysql-server php81 php81-mysql php81-mbstring php81-xml php81-curl php81-intl
```

### 2. Install Composer
```bash
# Download Composer
curl -sS https://getcomposer.org/installer | php

# Install globally (Linux/Mac)
sudo mv composer.phar /usr/local/bin/composer

# Windows: Download dari https://getcomposer.org/download/
```

### 3. Setup Database

#### Buat Database
```sql
-- Login ke MySQL
mysql -u root -p

-- Buat database
CREATE DATABASE db_manajemen_ac CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- Buat user (opsional, untuk keamanan)
CREATE USER 'ac_user'@'localhost' IDENTIFIED BY 'password_aman';
GRANT ALL PRIVILEGES ON db_manajemen_ac.* TO 'ac_user'@'localhost';
FLUSH PRIVILEGES;
```

#### Import Database
```bash
# Import struktur dan data
mysql -u root -p db_manajemen_ac < db_manajemen_ac.sql
```

### 4. Setup Aplikasi

#### Extract dan Copy Files
```bash
# Extract aplikasi ke direktori web server
# XAMPP: C:\xampp\htdocs\admin_ci4 (Windows) atau /opt/lampp/htdocs/admin_ci4 (Linux)
# Apache: /var/www/html/admin_ci4
# Nginx: /var/www/admin_ci4
```

#### Install Dependencies
```bash
# Masuk ke direktori aplikasi
cd /path/to/admin_ci4

# Install dependencies
composer install
```

#### Konfigurasi Environment
```bash
# Copy file environment
cp .env.example .env

# Edit file .env
nano .env
```

Sesuaikan konfigurasi berikut di file `.env`:
```ini
# Environment
CI_ENVIRONMENT = production

# Base URL
app.baseURL = 'http://localhost/admin_ci4/'

# Database
database.default.hostname = localhost
database.default.database = db_manajemen_ac
database.default.username = root
database.default.password = 
database.default.port = 3306

# Session
session.driver = 'CodeIgniter\Session\Handlers\FileHandler'
session.cookieName = 'ci_session'
session.expiration = 7200
```

### 5. Konfigurasi Web Server

#### Apache (.htaccess)
File `.htaccess` sudah disediakan. Pastikan mod_rewrite aktif:
```bash
# Ubuntu/Debian
sudo a2enmod rewrite
sudo systemctl restart apache2
```

Konfigurasi Virtual Host (opsional):
```apache
<VirtualHost *:80>
    ServerName admin-ac.local
    DocumentRoot /var/www/html/admin_ci4/public
    
    <Directory /var/www/html/admin_ci4/public>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

#### Nginx
```nginx
server {
    listen 80;
    server_name admin-ac.local;
    root /var/www/admin_ci4/public;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

### 6. Set Permissions
```bash
# Set permission untuk folder writable
chmod -R 755 writable/
chown -R www-data:www-data writable/ # Linux
# atau
chown -R apache:apache writable/ # CentOS
```

### 7. Testing Instalasi

#### Akses Aplikasi
Buka browser dan akses:
- `http://localhost/admin_ci4/` (jika di subfolder)
- `http://admin-ac.local/` (jika menggunakan virtual host)

#### Login Default
**Admin:**
- Username: `admin`
- Password: `admin123`

**Teknisi:**
- Username: `teknisi`
- Password: `teknisi123`

### 8. Konfigurasi Keamanan (Production)

#### Ganti Password Default
```sql
-- Login ke database dan ganti password
UPDATE users SET password = '$2y$10$NEW_HASHED_PASSWORD' WHERE username = 'admin';
```

#### Update Environment
```ini
# Set ke production
CI_ENVIRONMENT = production

# Nonaktifkan debug
app.CSPEnabled = true
```

#### Set Permission Ketat
```bash
# Set permission yang lebih ketat
find . -type f -exec chmod 644 {} \;
find . -type d -exec chmod 755 {} \;
chmod -R 777 writable/
```

## Troubleshooting

### Error "Database connection failed"
1. Periksa service MySQL berjalan
2. Verifikasi kredensial database di `.env`
3. Pastikan database sudah dibuat
4. Cek firewall/port 3306

### Error "404 Not Found"
1. Periksa mod_rewrite aktif (Apache)
2. Verifikasi file `.htaccess` ada
3. Periksa konfigurasi virtual host
4. Pastikan DocumentRoot mengarah ke folder `public/`

### Error "Permission denied"
1. Set permission folder `writable/`
2. Periksa ownership file (www-data/apache)
3. Disable SELinux sementara (CentOS)

### Error "Composer not found"
1. Install Composer global
2. Atau gunakan `php composer.phar` instead of `composer`

### Error "PHP version"
1. Update PHP ke versi 8.1+
2. Aktifkan ekstensi yang diperlukan
3. Restart web server

## Maintenance

### Update Aplikasi
```bash
# Backup database
mysqldump -u root -p db_manajemen_ac > backup.sql

# Update code
git pull origin main
composer update

# Clear cache
php spark cache:clear
```

### Backup Rutin
```bash
# Script backup otomatis
#!/bin/bash
DATE=$(date +%Y%m%d_%H%M%S)
mysqldump -u root -p db_manajemen_ac > backup_$DATE.sql
tar -czf app_backup_$DATE.tar.gz /path/to/admin_ci4
```

## Support

Jika mengalami masalah:
1. Periksa log error di `writable/logs/`
2. Aktifkan debug mode sementara
3. Periksa dokumentasi CodeIgniter 4
4. Buat issue di repository

## Keamanan

- Selalu gunakan HTTPS di production
- Update password default
- Backup database secara rutin
- Monitor log akses dan error
- Update framework secara berkala

