# Sistem Manajemen Teknisi AC - CodeIgniter 4

Aplikasi manajemen teknisi AC yang dikonversi dari PHP native ke framework CodeIgniter 4.

## Fitur Utama

### Admin Panel
- Dashboard dengan statistik ringkasan
- Manajemen pelanggan (CRUD)
- Manajemen pesanan layanan (CRUD)
- Manajemen teknisi (CRUD)
- Penjadwalan tugas teknisi
- Laporan pendapatan dan kinerja

### Panel Teknisi
- Dashboard tugas pribadi
- Check-in/Check-out tugas
- Update status tugas (pending, selesai)
- Detail informasi pelanggan dan lokasi

## Persyaratan Sistem

- PHP 8.1 atau lebih tinggi
- MySQL 5.7 atau lebih tinggi
- Web server (Apache/Nginx)
- Composer

## Instalasi

### 1. Persiapan Database
```sql
-- Import database
mysql -u root -p < db_manajemen_ac.sql
```

### 2. Konfigurasi Environment
```bash
# Copy file environment
cp .env.example .env

# Edit konfigurasi database di file .env
database.default.hostname = localhost
database.default.database = db_manajemen_ac
database.default.username = root
database.default.password = 
```

### 3. Install Dependencies
```bash
composer install
```

### 4. Jalankan Aplikasi
```bash
# Development server
php spark serve

# Atau gunakan web server
# Arahkan document root ke folder public/
```

## Akses Default

### Admin
- Username: `admin`
- Password: `admin123`

### Teknisi
- Username: `teknisi`
- Password: `teknisi123`

## Struktur Database

### Tabel Utama
- `users` - Data pengguna (admin/teknisi)
- `pelanggan` - Data pelanggan
- `pesanan_layanan` - Pesanan dari pelanggan
- `teknisi` - Data teknisi
- `penugasan` - Penjadwalan tugas teknisi
- `billing` - Data tagihan dan pembayaran

## Struktur Aplikasi

```
app/
├── Controllers/
│   ├── Auth.php          # Authentication
│   ├── Admin.php         # Admin panel
│   └── Teknisi.php       # Teknisi panel
├── Models/
│   ├── UserModel.php
│   ├── PelangganModel.php
│   ├── PesananLayananModel.php
│   ├── TeknisiModel.php
│   ├── PenugasanModel.php
│   └── BillingModel.php
├── Views/
│   ├── layouts/
│   ├── auth/
│   ├── admin/
│   └── teknisi/
└── Filters/
    └── AuthFilter.php    # Authentication filter
```

## Routing

### Authentication
- `GET /auth/login` - Halaman login
- `POST /auth/authenticate` - Proses login
- `GET /auth/logout` - Logout

### Admin Routes (Protected)
- `GET /admin/dashboard` - Dashboard admin
- `GET /admin/pelanggan` - Manajemen pelanggan
- `GET /admin/pesanan` - Manajemen pesanan
- `GET /admin/teknisi` - Manajemen teknisi
- `GET /admin/penjadwalan` - Penjadwalan tugas
- `GET /admin/laporan` - Laporan

### Teknisi Routes (Protected)
- `GET /teknisi/dashboard` - Dashboard teknisi
- `GET /teknisi/detail_tugas/{id}` - Detail tugas
- `GET /teknisi/check_in/{id}` - Check-in tugas
- `GET /teknisi/check_out/{id}` - Check-out tugas

## Keamanan

- CSRF Protection aktif
- Session-based authentication
- Role-based access control (Admin/Teknisi)
- Input validation dan sanitization
- Password hashing dengan bcrypt

## Pengembangan

### Menambah Fitur Baru
1. Buat model di `app/Models/`
2. Buat controller di `app/Controllers/`
3. Buat view di `app/Views/`
4. Tambahkan route di `app/Config/Routes.php`

### Testing
```bash
# Jalankan unit test
php spark test
```

## Troubleshooting

### Error Database Connection
- Pastikan MySQL service berjalan
- Periksa konfigurasi database di `.env`
- Pastikan database `db_manajemen_ac` sudah dibuat

### Error Permission
```bash
# Set permission untuk writable folder
chmod -R 777 writable/
```

### Error 404
- Pastikan mod_rewrite aktif (Apache)
- Periksa konfigurasi virtual host

## Konversi dari PHP Native

Aplikasi ini dikonversi dari PHP native dengan perubahan:

1. **Struktur MVC** - Memisahkan logic, data, dan presentation
2. **ORM/Query Builder** - Menggunakan CodeIgniter Query Builder
3. **Routing** - Menggunakan sistem routing CodeIgniter
4. **Security** - Implementasi CSRF, validation, dan authentication filter
5. **Template Engine** - Menggunakan CodeIgniter View dengan layout
6. **Error Handling** - Menggunakan exception handling CodeIgniter

## Lisensi

MIT License

## Support

Untuk pertanyaan atau bantuan, silakan buat issue di repository ini.

