<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Auth::login');

// Authentication routes
$routes->group('auth', function($routes) {
    $routes->get('login', 'Auth::login');
    $routes->post('authenticate', 'Auth::authenticate');
    $routes->get('logout', 'Auth::logout');
});

// Admin routes
$routes->group('admin', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'Admin::dashboard');
    
    // Pelanggan
    $routes->get('pelanggan', 'Admin::pelanggan');
    $routes->get('pelanggan/add', 'Admin::addPelanggan');
    $routes->post('pelanggan/add', 'Admin::addPelanggan');
    $routes->get('pelanggan/edit/(:num)', 'Admin::editPelanggan/$1');
    $routes->post('pelanggan/edit/(:num)', 'Admin::editPelanggan/$1');
    $routes->get('pelanggan/delete/(:num)', 'Admin::deletePelanggan/$1');
    
    // Pesanan
    $routes->get('pesanan', 'Admin::pesanan');
    $routes->get('pesanan/add', 'Admin::addPesanan');
    $routes->post('pesanan/add', 'Admin::addPesanan');
    $routes->get('pesanan/edit/(:num)', 'Admin::editPesanan/$1');
    $routes->post('pesanan/edit/(:num)', 'Admin::editPesanan/$1');
    $routes->get('pesanan/delete/(:num)', 'Admin::deletePesanan/$1');
    
    // Teknisi
    $routes->get('teknisi', 'Admin::teknisi');
    $routes->get('teknisi/add', 'Admin::addTeknisi');
    $routes->post('teknisi/add', 'Admin::addTeknisi');
    $routes->get('teknisi/edit/(:num)', 'Admin::editTeknisi/$1');
    $routes->post('teknisi/edit/(:num)', 'Admin::editTeknisi/$1');
    $routes->get('teknisi/delete/(:num)', 'Admin::deleteTeknisi/$1');
    
    // Penjadwalan
    $routes->get('penjadwalan', 'Admin::penjadwalan');
    $routes->post('penjadwalan/add', 'Admin::addPenjadwalan');
    $routes->get('penjadwalan/edit/(:num)', 'Admin::editPenjadwalan/$1');
    $routes->post('penjadwalan/edit/(:num)', 'Admin::editPenjadwalan/$1');
    $routes->get('penjadwalan/delete/(:num)', 'Admin::deletePenjadwalan/$1');
    
    // Laporan
    $routes->get('laporan', 'Admin::laporan');
    $routes->get('laporan/export', 'Admin::exportLaporan');
});

// Teknisi routes
$routes->group('teknisi', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'Teknisi::dashboard');
    $routes->get('detail_tugas/(:num)', 'Teknisi::detailTugas/$1');
    $routes->get('check_in/(:num)', 'Teknisi::checkIn/$1');
    $routes->get('check_out/(:num)', 'Teknisi::checkOut/$1');
    $routes->post('check_out/(:num)', 'Teknisi::checkOut/$1');
    $routes->get('set_pending/(:num)', 'Teknisi::setPending/$1');
    $routes->post('set_pending/(:num)', 'Teknisi::setPending/$1');
});

// API routes (jika diperlukan)
$routes->group('api', function($routes) {
    $routes->get('pelanggan', 'Api::getPelanggan');
    $routes->get('teknisi', 'Api::getTeknisi');
    $routes->get('pesanan', 'Api::getPesanan');
});

