<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\TeknisiModel;

class Auth extends BaseController
{
    protected $userModel;
    protected $teknisiModel;

    public function __construct()
    {
        $this->userModel = new UserModel();
        $this->teknisiModel = new TeknisiModel();
    }

    public function index()
    {
        // Redirect ke login
        return redirect()->to('/auth/login');
    }

    public function login()
    {
        // Jika sudah login, redirect ke dashboard
        if (session()->get('user_id')) {
            $role = session()->get('role');
            if ($role == 'admin') {
                return redirect()->to('/admin/dashboard');
            } elseif ($role == 'teknisi') {
                return redirect()->to('/teknisi/dashboard');
            }
        }

        $data = [
            'title' => 'Login - Sistem Manajemen Servis AC'
        ];

        return view('auth/login', $data);
    }

    public function authenticate()
    {
        $rules = [
            'username' => 'required',
            'password' => 'required'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        $user = $this->userModel->verifyPassword($username, $password);

        if ($user) {
            $sessionData = [
                'user_id' => $user['id'],
                'username' => $user['username'],
                'nama_lengkap' => $user['nama_lengkap'],
                'role' => $user['role'],
                'logged_in' => true
            ];

            // Jika teknisi, ambil teknisi_id
            if ($user['role'] == 'teknisi') {
                $teknisi = $this->teknisiModel->getTeknisiByUserId($user['id']);
                if ($teknisi) {
                    $sessionData['teknisi_id'] = $teknisi['id'];
                } else {
                    return redirect()->back()->with('error', 'Akun teknisi ini tidak terdaftar dengan benar.');
                }
            }

            session()->set($sessionData);

            // Redirect berdasarkan role
            if ($user['role'] == 'admin') {
                return redirect()->to('/admin/dashboard');
            } elseif ($user['role'] == 'teknisi') {
                return redirect()->to('/teknisi/dashboard');
            }
        } else {
            return redirect()->back()->with('error', 'Username atau password salah.');
        }
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('/auth/login')->with('success', 'Anda telah berhasil logout.');
    }

    public function checkAuth()
    {
        if (!session()->get('logged_in')) {
            return redirect()->to('/auth/login')->with('error', 'Silakan login terlebih dahulu.');
        }
    }

    public function checkAdminAuth()
    {
        $this->checkAuth();
        if (session()->get('role') !== 'admin') {
            return redirect()->to('/auth/login')->with('error', 'Akses ditolak. Hanya admin yang diizinkan.');
        }
    }

    public function checkTeknisiAuth()
    {
        $this->checkAuth();
        if (session()->get('role') !== 'teknisi') {
            return redirect()->to('/auth/login')->with('error', 'Akses ditolak. Hanya teknisi yang diizinkan.');
        }
    }
}

