<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        // Check if user is logged in
        if (!session()->get('logged_in')) {
            return redirect()->to('/auth/login')->with('error', 'Silakan login terlebih dahulu.');
        }

        // Check role-based access if arguments provided
        if ($arguments) {
            $userRole = session()->get('role');
            
            if (in_array('admin', $arguments) && $userRole !== 'admin') {
                return redirect()->to('/auth/login')->with('error', 'Akses ditolak. Hanya admin yang diizinkan.');
            }
            
            if (in_array('teknisi', $arguments) && $userRole !== 'teknisi') {
                return redirect()->to('/auth/login')->with('error', 'Akses ditolak. Hanya teknisi yang diizinkan.');
            }
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do something here
    }
}

