<?php

namespace App\Models;

use CodeIgniter\Model;

class PelangganModel extends Model
{
    protected $table = 'pelanggan';
    protected $primaryKey = 'id';
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $useSoftDeletes = false;
    protected $protectFields = true;
    protected $allowedFields = [
        'nama_pelanggan',
        'no_whatsapp',
        'alamat_lengkap',
        'koordinat_gps',
        'last_service_date'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat = 'datetime';
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    // Validation
    protected $validationRules = [
        'nama_pelanggan' => 'required|max_length[100]',
        'no_whatsapp' => 'required|max_length[20]',
        'alamat_lengkap' => 'required'
    ];

    protected $validationMessages = [];
    protected $skipValidation = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;

    public function getPelangganWithLastService()
    {
        return $this->select('pelanggan.*, MAX(penugasan.tanggal_penjadwalan) as last_service_date')
                    ->join('pesanan_layanan', 'pesanan_layanan.pelanggan_id = pelanggan.id', 'left')
                    ->join('penugasan', 'penugasan.pesanan_id = pesanan_layanan.id', 'left')
                    ->groupBy('pelanggan.id')
                    ->findAll();
    }

    public function searchPelanggan($keyword)
    {
        return $this->like('nama_pelanggan', $keyword)
                    ->orLike('no_whatsapp', $keyword)
                    ->orLike('alamat_lengkap', $keyword)
                    ->findAll();
    }
}

