<?php

namespace App\Models;

use CodeIgniter\Model;

class PesananLayananModel extends Model
{
    protected $table = 'pesanan_layanan';
    protected $primaryKey = 'id';
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $useSoftDeletes = false;
    protected $protectFields = true;
    protected $allowedFields = [
        'pelanggan_id',
        'keluhan_awal',
        'estimasi_biaya_awal',
        'status_pesanan'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat = 'datetime';
    protected $createdField = 'tanggal_pesanan';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    // Validation
    protected $validationRules = [
        'pelanggan_id' => 'required|integer',
        'keluhan_awal' => 'required',
        'estimasi_biaya_awal' => 'permit_empty|decimal',
        'status_pesanan' => 'permit_empty|in_list[baru,dijadwalkan,dikerjakan,pending,selesai,dibatalkan]'
    ];

    protected $validationMessages = [];
    protected $skipValidation = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;

    public function getPesananWithPelanggan()
    {
        return $this->select('pesanan_layanan.*, pelanggan.nama_pelanggan, pelanggan.no_whatsapp, pelanggan.alamat_lengkap')
                    ->join('pelanggan', 'pelanggan.id = pesanan_layanan.pelanggan_id')
                    ->orderBy('pesanan_layanan.tanggal_pesanan', 'DESC')
                    ->findAll();
    }

    public function getPesananByStatus($status)
    {
        return $this->select('pesanan_layanan.*, pelanggan.nama_pelanggan, pelanggan.no_whatsapp, pelanggan.alamat_lengkap')
                    ->join('pelanggan', 'pelanggan.id = pesanan_layanan.pelanggan_id')
                    ->where('pesanan_layanan.status_pesanan', $status)
                    ->orderBy('pesanan_layanan.tanggal_pesanan', 'DESC')
                    ->findAll();
    }

    public function updateStatus($id, $status)
    {
        return $this->update($id, ['status_pesanan' => $status]);
    }

    public function getStatistik()
    {
        $result = $this->select('status_pesanan, COUNT(*) as jumlah')
                       ->groupBy('status_pesanan')
                       ->findAll();
        
        $statistik = [];
        foreach ($result as $row) {
            $statistik[$row['status_pesanan']] = $row['jumlah'];
        }
        
        return $statistik;
    }
}

