<?php

namespace App\Models;

use CodeIgniter\Model;

class TeknisiModel extends Model
{
    protected $table = 'teknisi';
    protected $primaryKey = 'id';
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $useSoftDeletes = false;
    protected $protectFields = true;
    protected $allowedFields = [
        'user_id',
        'no_telepon',
        'alamat',
        'status'
    ];

    // Dates
    protected $useTimestamps = false;

    // Validation
    protected $validationRules = [
        'user_id' => 'required|integer',
        'no_telepon' => 'required|max_length[20]',
        'status' => 'permit_empty|in_list[tersedia,bertugas,tidak_aktif]'
    ];

    protected $validationMessages = [];
    protected $skipValidation = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;

    public function getTeknisiWithUser()
    {
        return $this->select('teknisi.*, users.nama_lengkap, users.username')
                    ->join('users', 'users.id = teknisi.user_id')
                    ->findAll();
    }

    public function getTeknisiTersedia()
    {
        return $this->select('teknisi.*, users.nama_lengkap')
                    ->join('users', 'users.id = teknisi.user_id')
                    ->where('teknisi.status', 'tersedia')
                    ->findAll();
    }

    public function updateStatus($id, $status)
    {
        return $this->update($id, ['status' => $status]);
    }

    public function getTeknisiByUserId($userId)
    {
        return $this->where('user_id', $userId)->first();
    }

    public function getTugasTeknisi($teknisiId)
    {
        return $this->db->table('penugasan')
                       ->select('penugasan.*, pesanan_layanan.keluhan_awal, pelanggan.nama_pelanggan, pelanggan.alamat_lengkap, pelanggan.no_whatsapp')
                       ->join('pesanan_layanan', 'pesanan_layanan.id = penugasan.pesanan_id')
                       ->join('pelanggan', 'pelanggan.id = pesanan_layanan.pelanggan_id')
                       ->where('penugasan.teknisi_id', $teknisiId)
                       ->orderBy('penugasan.tanggal_penjadwalan', 'DESC')
                       ->get()
                       ->getResultArray();
    }
}

