<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1><?= $title ?></h1>
    <a href="<?= base_url('admin/pelanggan') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form action="<?= base_url('admin/pelanggan/add') ?>" method="post">
            <?= csrf_field() ?>
            
            <div class="mb-3">
                <label for="nama_pelanggan" class="form-label">Nama Pelanggan *</label>
                <input type="text" class="form-control" id="nama_pelanggan" name="nama_pelanggan" 
                       value="<?= old('nama_pelanggan') ?>" required>
            </div>
            
            <div class="mb-3">
                <label for="no_whatsapp" class="form-label">No WhatsApp *</label>
                <input type="text" class="form-control" id="no_whatsapp" name="no_whatsapp" 
                       value="<?= old('no_whatsapp') ?>" required>
            </div>
            
            <div class="mb-3">
                <label for="alamat_lengkap" class="form-label">Alamat Lengkap *</label>
                <textarea class="form-control" id="alamat_lengkap" name="alamat_lengkap" 
                          rows="3" required><?= old('alamat_lengkap') ?></textarea>
            </div>
            
            <div class="mb-3">
                <label for="koordinat_gps" class="form-label">Koordinat GPS</label>
                <input type="text" class="form-control" id="koordinat_gps" name="koordinat_gps" 
                       value="<?= old('koordinat_gps') ?>" placeholder="Contoh: -6.200000, 106.816666">
                <div class="form-text">Format: latitude, longitude (opsional)</div>
            </div>
            
            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save me-1"></i>Simpan
                </button>
                <a href="<?= base_url('admin/pelanggan') ?>" class="btn btn-secondary">Batal</a>
            </div>
        </form>
    </div>
</div>
<?= $this->endSection() ?>

