<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<h1 class="mt-4"><?= $title ?></h1>
<p>Selamat datang di panel admin sistem manajemen teknisi AC.</p>

<div class="row">
    <div class="col-xl-3 col-md-6">
        <div class="card bg-primary text-white mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div><i class="bi bi-person-badge fs-1"></i></div>
                    <div class="text-end">
                        <div class="fs-3 fw-bold"><?= $total_teknisi ?></div>
                        <div>Total Teknisi</div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex align-items-center justify-content-between">
                <a class="small text-white stretched-link" href="<?= base_url('admin/teknisi') ?>">Lihat Detail</a>
                <div class="small text-white"><i class="bi bi-arrow-right"></i></div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card bg-warning text-white mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div><i class="bi bi-people fs-1"></i></div>
                    <div class="text-end">
                        <div class="fs-3 fw-bold"><?= $total_pelanggan ?></div>
                        <div>Total Pelanggan</div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex align-items-center justify-content-between">
                <a class="small text-white stretched-link" href="<?= base_url('admin/pelanggan') ?>">Lihat Detail</a>
                <div class="small text-white"><i class="bi bi-arrow-right"></i></div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card bg-success text-white mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div><i class="bi bi-journal-plus fs-1"></i></div>
                    <div class="text-end">
                        <div class="fs-3 fw-bold"><?= $pesanan_baru ?></div>
                        <div>Pesanan Baru</div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex align-items-center justify-content-between">
                <a class="small text-white stretched-link" href="<?= base_url('admin/pesanan') ?>">Lihat Detail</a>
                <div class="small text-white"><i class="bi bi-arrow-right"></i></div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card bg-danger text-white mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div><i class="bi bi-gear-wide-connected fs-1"></i></div>
                    <div class="text-end">
                        <div class="fs-3 fw-bold"><?= $tugas_berjalan ?></div>
                        <div>Tugas Berjalan</div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex align-items-center justify-content-between">
                <a class="small text-white stretched-link" href="<?= base_url('admin/penjadwalan') ?>">Lihat Detail</a>
                <div class="small text-white"><i class="bi bi-arrow-right"></i></div>
            </div>
        </div>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header"><i class="bi bi-calendar-check me-1"></i> Tugas yang Dijadwalkan Hari Ini</div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Teknisi</th>
                        <th>Pelanggan</th>
                        <th>Alamat</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($tugas_hari_ini)): ?>
                        <?php foreach ($tugas_hari_ini as $tugas): ?>
                            <tr>
                                <td><?= esc($tugas['nama_teknisi']) ?></td>
                                <td><?= esc($tugas['nama_pelanggan']) ?></td>
                                <td><?= esc($tugas['alamat_lengkap']) ?></td>
                                <td>
                                    <?php
                                    $statusClass = '';
                                    switch ($tugas['status_tugas']) {
                                        case 'akan_datang':
                                            $statusClass = 'badge bg-warning';
                                            break;
                                        case 'dikerjakan':
                                            $statusClass = 'badge bg-primary';
                                            break;
                                        case 'selesai':
                                            $statusClass = 'badge bg-success';
                                            break;
                                        case 'pending':
                                            $statusClass = 'badge bg-danger';
                                            break;
                                    }
                                    ?>
                                    <span class="<?= $statusClass ?>"><?= ucfirst(str_replace('_', ' ', $tugas['status_tugas'])) ?></span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center">Tidak ada tugas yang dijadwalkan hari ini.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

