<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1><?= $title ?></h1>
    <a href="<?= base_url('admin/pelanggan/add') ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle me-1"></i>Tambah Pelanggan
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Pelanggan</th>
                        <th>No WhatsApp</th>
                        <th>Alamat</th>
                        <th>Tanggal Daftar</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($pelanggan)): ?>
                        <?php foreach ($pelanggan as $index => $p): ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><?= esc($p['nama_pelanggan']) ?></td>
                                <td><?= esc($p['no_whatsapp']) ?></td>
                                <td><?= esc($p['alamat_lengkap']) ?></td>
                                <td><?= date('d/m/Y', strtotime($p['created_at'])) ?></td>
                                <td>
                                    <a href="<?= base_url('admin/pelanggan/edit/' . $p['id']) ?>" 
                                       class="btn btn-sm btn-warning">Edit</a>
                                    <a href="<?= base_url('admin/pelanggan/delete/' . $p['id']) ?>" 
                                       class="btn btn-sm btn-danger"
                                       onclick="return confirm('Yakin ingin menghapus pelanggan ini?')">Hapus</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">Tidak ada data pelanggan.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

