<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<h1 class="mt-4"><?= $title ?></h1>
<p>Selamat datang di panel teknisi sistem manajemen AC.</p>

<div class="row">
    <div class="col-md-4">
        <div class="card bg-warning text-white mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div><i class="bi bi-clock fs-1"></i></div>
                    <div class="text-end">
                        <div class="fs-3 fw-bold"><?= count($tugas_akan_datang) ?></div>
                        <div>Tugas Akan Datang</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-primary text-white mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div><i class="bi bi-gear-wide-connected fs-1"></i></div>
                    <div class="text-end">
                        <div class="fs-3 fw-bold"><?= count($tugas_dikerjakan) ?></div>
                        <div>Sedang Dikerjakan</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div><i class="bi bi-check-circle fs-1"></i></div>
                    <div class="text-end">
                        <div class="fs-3 fw-bold"><?= count($tugas_hari_ini) ?></div>
                        <div>Total Tugas</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <i class="bi bi-list-task me-1"></i> Daftar Tugas Saya
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Tanggal</th>
                        <th>Pelanggan</th>
                        <th>Alamat</th>
                        <th>Keluhan</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($tugas_hari_ini)): ?>
                        <?php foreach ($tugas_hari_ini as $tugas): ?>
                            <tr>
                                <td><?= date('d/m/Y', strtotime($tugas['tanggal_penjadwalan'])) ?></td>
                                <td><?= esc($tugas['nama_pelanggan']) ?></td>
                                <td><?= esc($tugas['alamat_lengkap']) ?></td>
                                <td><?= esc($tugas['keluhan_awal']) ?></td>
                                <td>
                                    <?php
                                    $statusClass = '';
                                    switch ($tugas['status_tugas']) {
                                        case 'akan_datang':
                                            $statusClass = 'badge bg-warning';
                                            break;
                                        case 'dikerjakan':
                                            $statusClass = 'badge bg-primary';
                                            break;
                                        case 'selesai':
                                            $statusClass = 'badge bg-success';
                                            break;
                                        case 'pending':
                                            $statusClass = 'badge bg-danger';
                                            break;
                                    }
                                    ?>
                                    <span class="<?= $statusClass ?>"><?= ucfirst(str_replace('_', ' ', $tugas['status_tugas'])) ?></span>
                                </td>
                                <td>
                                    <a href="<?= base_url('teknisi/detail_tugas/' . $tugas['id']) ?>" 
                                       class="btn btn-sm btn-info">Detail</a>
                                    
                                    <?php if ($tugas['status_tugas'] == 'akan_datang'): ?>
                                        <a href="<?= base_url('teknisi/check_in/' . $tugas['id']) ?>" 
                                           class="btn btn-sm btn-success">Check In</a>
                                    <?php elseif ($tugas['status_tugas'] == 'dikerjakan'): ?>
                                        <a href="<?= base_url('teknisi/check_out/' . $tugas['id']) ?>" 
                                           class="btn btn-sm btn-primary">Check Out</a>
                                        <a href="<?= base_url('teknisi/set_pending/' . $tugas['id']) ?>" 
                                           class="btn btn-sm btn-warning">Pending</a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">Tidak ada tugas yang tersedia.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

