<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1><?= $title ?></h1>
    <a href="<?= base_url('teknisi/dashboard') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Informasi Tugas</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <td width="30%"><strong>Tanggal Penjadwalan</strong></td>
                        <td><?= date('d/m/Y', strtotime($tugas['tanggal_penjadwalan'])) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Nama Pelanggan</strong></td>
                        <td><?= esc($tugas['nama_pelanggan']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>No WhatsApp</strong></td>
                        <td><?= esc($tugas['no_whatsapp']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Alamat</strong></td>
                        <td><?= esc($tugas['alamat_lengkap']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Keluhan Awal</strong></td>
                        <td><?= esc($tugas['keluhan_awal']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Status Tugas</strong></td>
                        <td>
                            <?php
                            $statusClass = '';
                            switch ($tugas['status_tugas']) {
                                case 'akan_datang':
                                    $statusClass = 'badge bg-warning';
                                    break;
                                case 'dikerjakan':
                                    $statusClass = 'badge bg-primary';
                                    break;
                                case 'selesai':
                                    $statusClass = 'badge bg-success';
                                    break;
                                case 'pending':
                                    $statusClass = 'badge bg-danger';
                                    break;
                            }
                            ?>
                            <span class="<?= $statusClass ?>"><?= ucfirst(str_replace('_', ' ', $tugas['status_tugas'])) ?></span>
                        </td>
                    </tr>
                    <?php if ($tugas['catatan_khusus']): ?>
                    <tr>
                        <td><strong>Catatan Khusus</strong></td>
                        <td><?= esc($tugas['catatan_khusus']) ?></td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>

        <?php if ($tugas['koordinat_gps']): ?>
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Lokasi GPS</h5>
            </div>
            <div class="card-body">
                <p><strong>Koordinat:</strong> <?= esc($tugas['koordinat_gps']) ?></p>
                <a href="https://maps.google.com/?q=<?= urlencode($tugas['koordinat_gps']) ?>" 
                   target="_blank" class="btn btn-info">
                    <i class="bi bi-geo-alt me-1"></i>Buka di Google Maps
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Aksi</h5>
            </div>
            <div class="card-body">
                <?php if ($tugas['status_tugas'] == 'akan_datang'): ?>
                    <a href="<?= base_url('teknisi/check_in/' . $tugas['id']) ?>" 
                       class="btn btn-success w-100 mb-2">
                        <i class="bi bi-play-circle me-1"></i>Check In
                    </a>
                <?php elseif ($tugas['status_tugas'] == 'dikerjakan'): ?>
                    <a href="<?= base_url('teknisi/check_out/' . $tugas['id']) ?>" 
                       class="btn btn-primary w-100 mb-2">
                        <i class="bi bi-stop-circle me-1"></i>Check Out
                    </a>
                    <a href="<?= base_url('teknisi/set_pending/' . $tugas['id']) ?>" 
                       class="btn btn-warning w-100">
                        <i class="bi bi-pause-circle me-1"></i>Set Pending
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <?php if ($tugas['waktu_check_in']): ?>
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Waktu Kerja</h5>
            </div>
            <div class="card-body">
                <p><strong>Check In:</strong><br><?= date('d/m/Y H:i:s', strtotime($tugas['waktu_check_in'])) ?></p>
                <?php if ($tugas['waktu_checkout']): ?>
                    <p><strong>Check Out:</strong><br><?= date('d/m/Y H:i:s', strtotime($tugas['waktu_checkout'])) ?></p>
                    <p><strong>Durasi:</strong><br><?= $tugas['durasi_kerja_menit'] ?> menit</p>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>

